/*
	File:		SliderPane.h

	Contains:	Class to drive our example slider pane in MegaDialog.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#pragma once

#include "MegaPane.h"
#include "Appearance.h"

class SliderPane : public MegaPane
{
	public:
			SliderPane( DialogPtr dialog, SInt16 items );
		virtual ~SliderPane();
		
		virtual void		ItemHit( SInt16 item );
	
	private:
		static pascal void	SliderFeedbackProc( ControlHandle control, SInt16 part );
		static pascal void	DrawPictureProc( ControlHandle control, SInt16 part );

		static ControlActionUPP	fSliderProc;
		static ControlUserPaneDrawUPP fDrawProc;
		
		ControlHandle		fVerticalSlider1;
		ControlHandle		fVerticalSlider2;
		ControlHandle		fVerticalSlider3;
		ControlHandle		fHorizontalSlider1;
		ControlHandle		fHorizontalSlider2;
		ControlHandle		fHorizontalSlider3;
		ControlHandle		fUserPane;
		
		PicHandle			fPicture;
		SInt16				fPictHeight;
		SInt16				fPictWidth;
};
